function stripPTags(htmlString = '') {
    if (!htmlString) return '';
    return htmlString.replace(/<\/?p>/g, '');
}

export function createNewQuestionObject() {
    return {
        "x": 2.18, "y": 3.87, "width": 37.96, "height": 21.38, "pause": true, "displayType": "poster",
        "duration": { "from": 0, "to": 0 },
        "action": {
            "library": "H5P.SingleChoiceSet 1.11",
            "params": {
                "choices": [{"question": "<p>Nouvelle question...</p>", "answers": ["<p>Bonne réponse</p>", "<p>Mauvaise réponse 1</p>", "<p>Mauvaise réponse 2</p>", "<p>Mauvaise réponse 3</p>"]}],
                "overallFeedback": [{ "from": 0, "to": 100, "feedback": "Rétroaction pour la bonne réponse." }],
                "behaviour": { "autoContinue": false, "timeoutCorrect": 2000, "timeoutWrong": 3000, "soundEffectsEnabled": true, "enableRetry": true, "enableSolutionsButton": false, "passPercentage": 100 }
            },
            "subContentId": `h5p-gen-${Math.random().toString(36).substring(2, 11)}`,
        },
        "adaptivity": { "correct": {}, "wrong": { "seek": 0 }, "requireCompletion": true }
    };
}

export function renderEditor(editorContent, updateCallback) {
    const settingsContainer = document.getElementById('h5p-behavior-settings');
    const questionsContainer = document.getElementById('editor-questions-container');

    if (!settingsContainer || !questionsContainer) {
        console.error("Les conteneurs de l'éditeur sont introuvables.");
        return;
    }

    settingsContainer.innerHTML = '';
    questionsContainer.innerHTML = '';

    if (!editorContent) {
        questionsContainer.innerHTML = '<h2>Éditeur</h2><p>Aucune question à afficher. Chargez une configuration depuis l\'onglet "Conception assistée par IA".</p>';
        return;
    }

    const override = editorContent.override ?? {};
    settingsContainer.innerHTML = `<h3>Navigation et Comportement</h3><div class="behavior-options-grid"><div class="behavior-option"><input type="checkbox" id="h5p-prevent-skipping" ${override.preventSkipping ?? true ? 'checked' : ''}><label for="h5p-prevent-skipping">Empêcher de sauter les questions</label></div><div class="behavior-option"><input type="checkbox" id="h5p-autoplay" ${override.autoplay ?? false ? 'checked' : ''}><label for="h5p-autoplay">Lecture automatique</label></div><div class="behavior-option"><input type="checkbox" id="h5p-loop" ${override.loop ?? false ? 'checked' : ''}><label for="h5p-loop">Lire en boucle</label></div></div>`;

    const interactions = editorContent.interactiveVideo.assets.interactions || [];
    if (interactions.length > 0) {
        questionsContainer.innerHTML = '<h2>Questions</h2>';
    }
    
    interactions.forEach((interaction, qIndex) => {
        const choiceData = interaction.action.params.choices[0];
        const answers = choiceData.answers;
        let answersHtml = '';
        const trashIconSvg = `<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-trash-2"><polyline points="3 6 5 6 21 6"></polyline><path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path><line x1="10" y1="11" x2="10" y2="17"></line><line x1="14" y1="11" x2="14" y2="17"></line></svg>`;

        answers.forEach((answer, aIndex) => {
            answersHtml += `<div class="answer-group">
                <input type="radio" name="correct-answer-${qIndex}" value="${aIndex}" ${aIndex === 0 ? 'checked' : ''} data-q-index="${qIndex}" data-type="correct-index">
                <textarea class="answer-input" rows="1" data-q-index="${qIndex}" data-a-index="${aIndex}" data-type="answer-text">${stripPTags(answer)}</textarea>
                <button class="delete-answer-btn" data-q-index="${qIndex}" data-a-index="${aIndex}" title="Supprimer cette réponse">${trashIconSvg}</button>
            </div>`;
        });

        const behaviour = interaction.action.params.behaviour ?? {};
        const adaptivity = interaction.adaptivity ?? {};
        
        const advancedOptionsHtml = `<div class="advanced-options"><details><summary>Options avancées de comportement</summary><div class="advanced-options-grid"><div class="behavior-option"><input type="checkbox" data-type="behaviour-autocontinue" ${behaviour.autoContinue ?? false ? 'checked' : ''}><label>Continuer automatiquement</label></div><div class="behavior-option"><input type="checkbox" data-type="behaviour-enableretry" ${behaviour.enableRetry ?? true ? 'checked' : ''}><label>Permettre de réessayer</label></div><div class="behavior-option"><input type="checkbox" data-type="behaviour-enablesolutions" ${behaviour.enableSolutionsButton ?? false ? 'checked' : ''}><label>Afficher le bouton "Solution"</label></div><div class="behavior-option"><input type="checkbox" data-type="behaviour-soundeffects" ${behaviour.soundEffectsEnabled ?? true ? 'checked' : ''}><label>Activer les effets sonores</label></div><div class="behavior-option"><input type="checkbox" data-type="adaptivity-requirecompletion" ${adaptivity.requireCompletion ?? true ? 'checked' : ''}><label>Exiger une réponse</label></div></div><div class="advanced-options-grid" style="margin-top: 1em;"><div class="form-group-editor"><label>Délai si correct (ms)</label><input type="number" value="${behaviour.timeoutCorrect ?? 2000}" data-type="behaviour-timeoutcorrect"></div><div class="form-group-editor"><label>Délai si incorrect (ms)</label><input type="number" value="${behaviour.timeoutWrong ?? 3000}" data-type="behaviour-timeoutwrong"></div></div></details></div>`;
        
        const questionCardHtml = `<div class="question-card" data-q-index="${qIndex}">
            <button class="delete-question-btn" data-q-index="${qIndex}" title="Supprimer cette question">${trashIconSvg}</button>
            <h3>Question ${qIndex + 1}</h3>
            <div class="form-group-editor"><label>Texte de la question</label><textarea data-q-index="${qIndex}" data-type="question-text">${stripPTags(choiceData.question)}</textarea></div>
            <div class="form-group-editor"><label>Choix de réponse</label><div class="answers-container">${answersHtml}</div></div>
            <div class="form-grid-editor">
                <div class="form-group-editor"><label>Temps d'apparition (sec)</label><input type="number" value="${interaction.duration.to}" data-q-index="${qIndex}" data-type="appearance-time"></div>
                <div class="form-group-editor"><label>Retour en arrière (sec)</label><input type="number" value="${interaction.adaptivity.wrong.seek ?? interaction.adaptivity.wrong.seekTo ?? 0}" data-q-index="${qIndex}" data-type="seek-back-time"></div>
            </div>
            <div class="form-group-editor"><label>Rétroaction</label><textarea data-q-index="${qIndex}" data-type="feedback">${interaction.action.params.overallFeedback[0].feedback}</textarea></div>
            ${advancedOptionsHtml}
        </div>`;
        questionsContainer.innerHTML += questionCardHtml;
    });

    // Auto-ajustement de la hauteur des textareas
    function autoResizeTextarea(event) {
        event.target.style.height = 'auto';
        event.target.style.height = (event.target.scrollHeight) + 'px';
    }

    document.querySelectorAll('textarea.answer-input').forEach(textarea => {
        textarea.addEventListener('input', autoResizeTextarea);
        // Ajustement initial
        textarea.style.height = 'auto';
        textarea.style.height = (textarea.scrollHeight) + 'px';
    });

    document.getElementById('tab-editor').querySelectorAll('input, textarea').forEach(field => {
        const eventType = field.type === 'checkbox' || field.type === 'radio' ? 'change' : 'blur';
        field.addEventListener(eventType, updateCallback);
    });
}